package com.agilex.healthcare.mobilehealthplatform.domain.formatters;

import com.agilex.healthcare.mobilehealthplatform.domain.Address;
import com.agilex.healthcare.utility.NullChecker;

public class AddressDispayFormatter {
	private static final String CITYSTATE_DELIM = ", ";
	private static final String ZIP_DELIM = " ";
	private static final String STREETADDRESS_DELIM = CITYSTATE_DELIM;
	public static final String newline = "\n";

	public void createFormatDisplay(Address a) {
		if (a != null) {
			String addressLine = null;
			addressLine = appendAddress(addressLine, a.getStreetAddressLine1(), STREETADDRESS_DELIM);
			addressLine = appendAddress(addressLine, a.getStreetAddressLine2(), STREETADDRESS_DELIM);
			addressLine = appendAddress(addressLine, a.getStreetAddressLine3(), STREETADDRESS_DELIM);
			a.setFormattedDisplayAddress1(addressLine);

			String citystateline = null;
			citystateline = appendAddress(citystateline, a.getCity(), null);
			citystateline = appendAddress(citystateline, a.getState(), CITYSTATE_DELIM);
			citystateline = appendAddress(citystateline, a.getZipCode(), ZIP_DELIM);

			if (NullChecker.isNullish(a.getFormattedDisplayAddress1()))
				a.setFormattedDisplayAddress1(citystateline);
			else {
				a.setFormattedDisplayAddress2(citystateline);
			}
		}
	}

	private String appendAddress(String current, String nextPart, String delim) {
		if (NullChecker.isNotNullish(nextPart)) {
			if (NullChecker.isNotNullish(current))
				current += delim;
			else {
				current = "";
			}
			current += nextPart;
		}
		return current;
	}

}
