package com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter;

import java.util.Date;
import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.Dateable;
import com.agilex.healthcare.utility.ObjectInstatiator;

public class DateFilterer {
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(DateFilterer.class);

	public static <Ts extends List<T>, T extends Dateable> Ts filterByDate(Ts items, DateFilter filter) {
		if (filter == null || items == null)
			return items;

		LOGGER.debug("begin date filterer");

		Ts filteredItems = ObjectInstatiator.createObjectOfSameType(items);

		for (T item : items) {
			if (DateFilterer.meetsDateFilter(item, filter)) {
				filteredItems.add(item);
			}
		}

		LOGGER.debug("end date filterer");

		return filteredItems;
	}

	public static boolean meetsDateFilter(Dateable item, DateFilter filter) {
		return meetsDateFilter(item.getDate(), filter.getStartDate(), filter.getEndDate());
	}

	public static boolean meetsDateFilter(Date dateToCheck, Date filterBeginDate, Date filterEndDate) {
		return meetsBeginDateFilter(dateToCheck, filterBeginDate) && meetsEndDateFilter(dateToCheck, filterEndDate);
	}

	public static boolean meetsBeginDateFilter(Date dateToCheck, Date filterDate) {
		boolean result;
		if (filterDate == null) {
			result = true;
		} else if (dateToCheck == null) {
			result = false;
		} else {
			result = !dateToCheck.before(filterDate);
		}
		return result;
	}

	public static boolean meetsEndDateFilter(Date dateToCheck, Date filterDate) {
		boolean result;
		if (filterDate == null) {
			result = true;
		} else if (dateToCheck == null) {
			result = false;
		} else {
			result = !dateToCheck.after(filterDate);
		}
		return result;
	}
}
