package com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter;

import com.agilex.healthcare.mobilehealthplatform.utils.NullableValue;
import com.agilex.healthcare.mobilehealthplatform.utils.QueryParameters;
import com.agilex.healthcare.utility.NullChecker;

public class DateFilterQueryParameters {
	private QueryParameters queryParameters;

	public DateFilterQueryParameters(QueryParameters queryParameters) {
		this.queryParameters = queryParameters;
	}

	public NullableValue getEntryDate() {
		final String ENTRYDATE__QUERYPARAMKEY = "entryDate";
		final String ENTRYDATE_ALTERNATE_QUERYPARAMKEY = "date";
		return getFirstValueFound(queryParameters, ENTRYDATE__QUERYPARAMKEY, ENTRYDATE_ALTERNATE_QUERYPARAMKEY);
	}

	public NullableValue getStartDate() {
		final String STARTDATE__QUERYPARAMKEY = "startDate";
		final String STARTDATE_ALTERNATE_QUERYPARAMKEY = "beginDate";
		return getFirstValueFound(queryParameters, STARTDATE__QUERYPARAMKEY, STARTDATE_ALTERNATE_QUERYPARAMKEY);
	}

	public NullableValue getEndDate() {
		final String ENDDATE__QUERYPARAMKEY = "endDate";
		final String ENDDATE_ALTERNATE_QUERYPARAMKEY = "stopDate";
		return getFirstValueFound(queryParameters, ENDDATE__QUERYPARAMKEY, ENDDATE_ALTERNATE_QUERYPARAMKEY);
	}

	public NullableValue getReferenceDate() {
		final String REFERENCEDATE__QUERYPARAM = "referenceDate";
		return getFirstValueFound(queryParameters, REFERENCEDATE__QUERYPARAM);
	}

	public NullableValue getSlidingScaleMonthsInPast() {
		final String SLIDINGSCALE_MONTHSINPAST__QUERYPARAMETER = "numberOfPastMonths";
		final String SLIDINGSCALE_MONTHSINPAST__QUERYPARAMETER_ALTERNATE = "numberOfMonthsInPast";
		return getFirstValueFound(queryParameters, SLIDINGSCALE_MONTHSINPAST__QUERYPARAMETER, SLIDINGSCALE_MONTHSINPAST__QUERYPARAMETER_ALTERNATE);
	}

	public NullableValue getSlidingScaleMonthsInFuture() {
		final String SLIDINGSCALE_MONTHSINFUTURE__QUERYPARAMETER = "numberOfFutureMonths";
		final String SLIDINGSCALE_MONTHSINFUTURE__QUERYPARAMETER_ALTERNATE = "numberOfMonthsInFuture";
		return getFirstValueFound(queryParameters, SLIDINGSCALE_MONTHSINFUTURE__QUERYPARAMETER, SLIDINGSCALE_MONTHSINFUTURE__QUERYPARAMETER_ALTERNATE);
	}

	private NullableValue getFirstValueFound(QueryParameters queryParameters, String... keys) {
		String result = null;
		for (String keyInParamArray : keys) {
			result = queryParameters.getValue(keyInParamArray);
			if (NullChecker.isNotNullish(result))
				break;
		}
		return new NullableValue(result);
	}
}
