package com.agilex.healthcare.mobilehealthplatform.domain.filter;

import java.util.Date;

import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.NullSafeStringComparer;

//TODO: move this to a utility class rather than a base class
public class BaseFilterer {

	public static boolean isBetweenDates(Date dateToCheck, Date startDate, Date endDate) {
		return DateFilterer.meetsDateFilter(dateToCheck, startDate, endDate);
	}

	protected static boolean matchesStringIgnoreEmpty(String possibleMatch, String expected) {
		if (NullChecker.isNullish(expected)) {
			return true;
		}
		return matchesString(possibleMatch, expected);
	}

	protected static boolean matchesString(String possibleMatch, String expected) {
		return NullSafeStringComparer.areEqual(possibleMatch, expected);
	}
}
