package com.agilex.healthcare.mobilehealthplatform.domain.code;
import java.util.HashMap;
import java.util.Map;
import com.agilex.healthcare.utility.NullChecker;

public class VitalSectionCode {
	public static final String DEFAULT_TITLE = "Vitals";
	public static final String BloodPressure = "BP";
	public static final String Pulse = "pulse";
	public static final String Temperature = "temperature";
	public static final String Respiration = "respiration";
	public static final String Pain = "pain";
	public static final String Mood = "mood";
	public static final String Height = "height";
	public static final String Weight = "weight";
	public static final String PulseOximetry = "pulse-ox";

	private static final Map<String, String> titleMap = new HashMap<String, String>();
		static{
			titleMap.put(BloodPressure, "Blood Pressure");
			titleMap.put(Pulse, "Pulse");
			titleMap.put(Temperature, "Temperature");
			titleMap.put(Pain, "Pain");
			titleMap.put(Respiration, "Respiration");
			titleMap.put(Mood, "Mood");
			titleMap.put(Height, "Height");
			titleMap.put(Weight, "Weight");
			titleMap.put(PulseOximetry, "Pulse Oximetry");
		}
		private VitalSectionCode(){
		}
		public static String getTitle(String key){
			String title = titleMap.get(key);

			if(NullChecker.isNullish(title)){
				title = DEFAULT_TITLE;
			}
			return title;
	}
}
