package com.agilex.healthcare.mobilehealthplatform.domain.antibiogram;

import java.util.Collection;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObjectCollection;
import com.agilex.healthcare.mobilehealthplatform.domain.Namespace;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "organisms", namespace = Namespace.MobileHealthPlatform)
public class Organisms extends DomainTransferObjectCollection<Organism> {

	private static final long serialVersionUID = -8462211845534534808L;

	public Organisms() {}
	
	private OrganismGroups organismGroups = new OrganismGroups();
	
	public Organisms(Organism... organisms) {
		for(int i = 0; i < organisms.length; i++) {
			this.add(organisms[i]);
		}
	}
	
	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<Organism> getOrganism() {
		return this;
	}

	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public OrganismGroups getOrganismGroups() {
		return organismGroups;
	}

	public void setOrganismGroups(OrganismGroups organismGroups) {
		this.organismGroups = organismGroups;
	}
	
	
}
