package com.agilex.healthcare.mobilehealthplatform.domain.antibiogram;

import java.util.Collection;

import javax.xml.bind.annotation.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "organism-groups", namespace = Namespace.MobileHealthPlatform)
public class OrganismGroups extends DomainTransferObjectCollection<OrganismGroup> {

	private static final long serialVersionUID = -6301379386940400795L;

	public OrganismGroups() {}
	
	public OrganismGroups(OrganismGroup... organismGroups) {
		for(int i = 0; i < organismGroups.length; i++) {
			this.add(organismGroups[i]);
		}
	}
	
	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<OrganismGroup> getOrganismGroup() {
		return this;
	}
	
}
