package com.agilex.healthcare.mobilehealthplatform.domain.antibiogram;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.mobilehealthplatform.domain.Namespace;

@XmlRootElement(name = "organism-group", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class OrganismGroup extends DomainTransferObject {

	private static final long serialVersionUID = 7366177476081537116L;

	@XmlElement
	private String id;
	@XmlElement
	private String name;
	@XmlElement
	private String facilityCode;
	@XmlElement
	private String organismName;
	@XmlElement
	private String organismId;

	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getFacilityCode() {
		return facilityCode;
	}
	public void setFacilityCode(String facilityCode) {
		this.facilityCode = facilityCode;
	}
	public String getOrganismName() {
		return organismName;
	}
	public void setOrganismName(String organismName) {
		this.organismName = organismName;
	}
	public String getOrganismId() {
		return organismId;
	}
	public void setOrganismId(String organismId) {
		this.organismId = organismId;
	}
	
}
