package com.agilex.healthcare.mobilehealthplatform.domain.antibiogram;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.mobilehealthplatform.domain.Namespace;

@XmlRootElement(name = "organismAntibiogramMatrix", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class OrganismAntibiogramMatrix extends DomainTransferObject {

	private static final long serialVersionUID = -7509145573221847091L;
	
	@XmlElement
	private String organismName;
	@XmlElement
	private String maxCount;
	@XmlElement
	private AntibiogramSummaries antibiogramSummaries;
	
	public String getOrganismName() {
		return organismName;
	}
	public void setOrganismName(String organismName) {
		this.organismName = organismName;
	}
	public String getMaxCount() {
		return maxCount;
	}
	public void setMaxCount(String maxCount) {
		this.maxCount = maxCount;
	}
	public AntibiogramSummaries getAntibiogramSummaries() {
		return antibiogramSummaries;
	}
	public void setAntibiogramSummaries(AntibiogramSummaries antibiogramSummaries) {
		this.antibiogramSummaries = antibiogramSummaries;
	}

}
