package com.agilex.healthcare.mobilehealthplatform.domain.antibiogram;

import javax.xml.bind.annotation.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;

@XmlRootElement(name = "organism", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class Organism extends DomainTransferObject {

	private static final long serialVersionUID = -3306757732192324916L;

	@XmlElement
	private String id;
	@XmlElement
	private String name;
	@XmlElement
	private String type;
	@XmlElement
	private String facilitySiteCode;
	
	public Organism() {}
	
	public Organism(String id, String name, String type) {
		this.id = id;
		this.name = name;
		this.type = type;
	}
	
	public Organism(String id, String name, String type, String facilitySiteCode) {
		this.id = id;
		this.name = name;
		this.type = type;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getFacilitySiteCode() {
		return facilitySiteCode;
	}

	public void setFacilitySiteCode(String facilitySiteCode) {
		this.facilitySiteCode = facilitySiteCode;
	}

}
