package com.agilex.healthcare.mobilehealthplatform.domain.antibiogram;

import javax.xml.bind.annotation.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;

@XmlRootElement(name = "antibiogramSummary", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class AntibiogramSummary extends DomainTransferObject {

	private static final long serialVersionUID = 7951752345737965030L;

	@XmlElement
	private String antibioticId;
	@XmlElement
	private String antibioticName;
	@XmlElement
	private String organismId;
	@XmlElement
	private String organismName;
	@XmlElement
	private String facilitySiteCode;
	@XmlElement
	private String testCount;
	@XmlElement
	private String sensitivityCount;
	


	public String getAntibioticId() {
		return antibioticId;
	}

	public void setAntibioticId(String antibioticId) {
		this.antibioticId = antibioticId;
	}

	public String getAntibioticName() {
		return antibioticName;
	}

	public void setAntibioticName(String antibioticName) {
		this.antibioticName = antibioticName;
	}

	public String getOrganismId() {
		return organismId;
	}

	public void setOrganismId(String organismId) {
		this.organismId = organismId;
	}

	public String getOrganismName() {
		return organismName;
	}

	public void setOrganismName(String organismName) {
		this.organismName = organismName;
	}

	public String getFacilitySiteCode() {
		return facilitySiteCode;
	}

	public void setFacilitySiteCode(String facilitySiteCode) {
		this.facilitySiteCode = facilitySiteCode;
	}

	public String getTestCount() {
		return testCount;
	}

	public void setTestCount(String testCount) {
		this.testCount = testCount;
	}

	public String getSensitivityCount() {
		return sensitivityCount;
	}

	public void setSensitivityCount(String sensitivityCount) {
		this.sensitivityCount = sensitivityCount;
	}

	@XmlElement
	public String getRatio() {
		try {
			int sentitivity = Integer.parseInt(this.sensitivityCount);
			int tests = Integer.parseInt(this.testCount);
			
			double ratio = (sentitivity / tests) * 100;
			
			return new Double(ratio).toString();
		} catch(NumberFormatException nfe) {
			return "0";
		}
	}


}
