package com.agilex.healthcare.mobilehealthplatform.domain.antibiogram;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.mobilehealthplatform.domain.Namespace;


@XmlRootElement(name = "antibiogramMatrix", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class AntibiogramMatrix extends DomainTransferObject {

	private static final long serialVersionUID = 7760527198350592698L;

	@XmlElement
	private List<String> antibiotics = new ArrayList<String>();
	@XmlElement
	private List<OrganismAntibiogramMatrix> organismAntibiogramMatrices = new ArrayList<OrganismAntibiogramMatrix>();

	public List<String> getAntibiotics() {
		return antibiotics;
	}

	public void setAntibiotics(List<String> antibiotics) {
		this.antibiotics = antibiotics;
	}

	public List<OrganismAntibiogramMatrix> getOrganismAntibiogramMatrices() {
		return organismAntibiogramMatrices;
	}

	public void setOrganismAntibiogramMatrices(
			List<OrganismAntibiogramMatrix> organismAntibiogramMatrices) {
		this.organismAntibiogramMatrices = organismAntibiogramMatrices;
	}

	@Override
	@XmlElement(name = "object-type")
	public String getObjectType() {
		return this.getClass().getSimpleName();
	}

}
