package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlRootElement(name = "vitalTableRow", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class VitalTableRow extends PatientData {

	private static final long serialVersionUID = 2246328779129755131L;

	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date entryTime;
	@XmlElement
	private String systolic;
	@XmlElement
	private String diastolic;
	@XmlElement
	private String pulse;
	@XmlElement
	private String weight;
	@XmlElement
	private String height;
	@XmlElement
	private String temperature;
	@XmlElement
	private String respiration;
	@XmlElement
	private String pain;
	@XmlElement
	private String pulseOximetry;

	public Date getEntryTime() {
		return entryTime;
	}

	public void setEntryTime(Date entryTime) {
		this.entryTime = entryTime;
	}

	public String getSystolic() {
		return systolic;
	}

	public void setSystolic(String systolic) {
		this.systolic = systolic;
	}

	public String getDiastolic() {
		return diastolic;
	}

	public void setDiastolic(String diastolic) {
		this.diastolic = diastolic;
	}

	public String getWeight() {
		return weight;
	}

	public void setWeight(String weight) {
		this.weight = weight;
	}

	public String getHeight() {
		return height;
	}

	public void setHeight(String height) {
		this.height = height;
	}

	public String getTemperature() {
		return temperature;
	}

	public void setTemperature(String temperature) {
		this.temperature = temperature;
	}

	public String getRespiration() {
		return respiration;
	}

	public void setRespiration(String respiration) {
		this.respiration = respiration;
	}

	public String getPain() {
		return pain;
	}

	public void setPain(String pain) {
		this.pain = pain;
	}

	public String getPulse() {
		return pulse;
	}

	public void setPulse(String pulse) {
		this.pulse = pulse;
	}

	public String getPulseOximetry() {
		return pulseOximetry;
	}

	public void setPulseOximetry(String pulseOximetry) {
		this.pulseOximetry = pulseOximetry;
	}

}
