package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@Entity
@Table(name="VITAL_SIGN")
@XmlRootElement(namespace = Namespace.MobileHealthPlatform)
public class VitalSign extends DomainTransferObject {
	private static final long serialVersionUID = 2413963440526793070L;
	@XmlAttribute
	private Integer vitalId = null;
	@XmlAttribute
	private String vitalType = null;
	@XmlAttribute
	private String qualifier = null;
	@XmlAttribute
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date measuredDate = null;
	@XmlAttribute
	private String value = null;
	@XmlAttribute
	private String valueUnits = null;
	@XmlTransient
	private String patientId = null;
	@XmlAttribute
	private String referenceHigh = null;
	@XmlAttribute
	private String referenceLow = null;
	
	@Id
	@GeneratedValue
	@Column(name="VITAL_SIGN_ID")
	public Integer getVitalId() {
		return vitalId;
	}
	
	public void setVitalId(String vitalId) {
		try {
			this.vitalId = Integer.parseInt(vitalId);
		} catch (NumberFormatException ignoreVitalIdForPersistence) {
			
		}
	}
	
	
	public void setVitalId(Integer vitalId) {
		this.vitalId = vitalId;
	}
	
	@Column(name="TYPE_CODE")
	public String getVitalType() {
		return vitalType;
	}

	public void setVitalType(String typeCode) {
		this.vitalType = typeCode;
	}

	@Column(name="QUALIFIER")
	public String getQualifier() {
		return qualifier;
	}
	
	public void setQualifier(String qualifier) {
		this.qualifier = qualifier;
	}
	
	@Column(name="MEASURED_DATE")
	public Date getMeasuredDate() {
		return measuredDate;
	}
	
	public void setMeasuredDate(Date measuredDate) {
		this.measuredDate = measuredDate;
	}
	
	@Column(name="VALUE")
	public String getValue() {
		return value;
	}
	
	public void setValue(String value) {
		this.value = value;
	}
	
	@Column(name="UNITS")
	public String getValueUnits() {
		return valueUnits;
	}

	public void setValueUnits(String units) {
		this.valueUnits = units;
	}
	
	@Column(name="PATIENT_ID")
	public String getPatientId() {
		return patientId;
	}
	
	public void setPatientId(String patientId) {
		this.patientId = patientId;
	}
	
	@Column(name="REF_HIGH")
	public String getReferenceHigh() {
		return referenceHigh;
	}
	
	public void setReferenceHigh(String referenceHigh) {
		this.referenceHigh = referenceHigh;
	}
	
	@Column(name="REF_LOW")
	public String getReferenceLow() {
		return referenceLow;
	}
	
	public void setReferenceLow(String referenceLow) {
		this.referenceLow = referenceLow;
	}
}
