package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.utility.NullChecker;

@XmlRootElement(name = "vitalObsevation", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class VitalObservation extends PatientData {

	private static final long serialVersionUID = -2859594481709036336L;
	
	@XmlAttribute
	private String type;
	@XmlAttribute
	private String value;
	@XmlAttribute
	private String valueUnits;

	private VitalEntry vitalEntry;

	@Id
	@GeneratedValue
	@Column(name = "VITAL_OBSERVATION_ID")
	public String getId() {
		return this.getDataIdentifier().getUniqueId();
	}

	public void setId(String id) {
		this.getDataIdentifier().setUniqueId(id);
	}

	@Column(name = "TYPE")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Column(name = "VALUE")
	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	@Column(name = "UNITS")
	public String getValueUnits() {
		return valueUnits;
	}

	public void setValueUnits(String valueUnits) {
		this.valueUnits = valueUnits;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "VITAL_ENTRY_ID", nullable = false)
	public VitalEntry getVitalEntry() {
		return vitalEntry;
	}

	public void setVitalEntry(VitalEntry vitalEntry) {
		this.vitalEntry = vitalEntry;
	}

	@Transient
	public Integer getValueAsIntegerByType() {
		if (NullChecker.isNullish(this.value))
			return null;
		return Integer.parseInt(this.value);
	}

	@Transient
	public Double getValueAsDouble() {
		if (NullChecker.isNullish(this.value))
			return null;

		try {
            return Double.parseDouble(this.value);
        } catch(NumberFormatException nfe) {
            return null;
        }
	}

}
