package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.*;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.*;

import com.agilex.healthcare.utility.*;
import com.agilex.healthcare.utility.datemarshallers.*;

@XmlRootElement(name = "vitalEntry", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class VitalEntry extends PatientData implements Dateable {

	private static final long serialVersionUID = 7107581483910955021L;

	@XmlElement
	private String section;
	@XmlElement
	private String notes;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date entryDate;
	@XmlElement
	private String qualifier;
	@XmlElement
	private List<VitalObservation> vitalObservations = new ArrayList<VitalObservation>();


	public String getId() {
		return this.getDataIdentifier().getUniqueId();
	}

	public void setId(String id) {
		this.getDataIdentifier().setUniqueId(id);
	}

	public String getPatientId() {
		return this.getPatientIdentifier().getUniqueId();
	}

	@Override
	public void setPatientId(String patientId) {
		this.getPatientIdentifier().setUniqueId(patientId);
	}

	public String getSection() {
		return section;
	}

	public void setSection(String section) {
		this.section = section;
	}

	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}

	public Date getEntryDate() {
		return entryDate;
	}

	public void setEntryDate(Date entryDate) {
		this.entryDate = entryDate;
	}

	public String getQualifier() {
		return qualifier;
	}

	public void setQualifier(String qualifier) {
		this.qualifier = qualifier;
	}

	public List<VitalObservation> getVitalObservations() {
		return vitalObservations;
	}

	public void setVitalObservations(List<VitalObservation> vitalObservations) {
		this.vitalObservations = vitalObservations;
	}
	
	public void addObservation(VitalObservation vitalObservation) {
		if(this.vitalObservations == null) {
			this.vitalObservations = new ArrayList<VitalObservation>();
		}
		
		vitalObservations.add(vitalObservation);
	}

	public String getObservationValueByType(String observationType) {
		VitalObservation observation = getObservationByType(observationType);
		String observationValue = null;
		if (observation != null)
			observationValue = observation.getValue();
		return observationValue;
	}

	public Integer getObservationValueAsIntegerByType(String observationType) {
		String observationValueAsString = getObservationValueByType(observationType);
		if (NullChecker.isNullish(observationValueAsString))
			return null;
		return Integer.parseInt(observationValueAsString);
	}

	public Double getObservationValueAsDoubleByType(String observationType) {
		String observationValueAsString = getObservationValueByType(observationType);
		if (NullChecker.isNullish(observationValueAsString))
			return null;
		return Double.parseDouble(observationValueAsString);
	}

	public VitalObservation getObservationByType(String observationType) {
		VitalObservation observation = null;
		for (VitalObservation potentialMatch : this.vitalObservations) {
			if (NullSafeStringComparer.areEqual(observationType, potentialMatch.getType())) {
				observation = potentialMatch;
				break;
			}
		}
		return observation;
	}

	public void setObservationValueByType(String observationType, String observationValue) {
		VitalObservation observation = getObservationByType(observationType);
		if (observation == null) {
			observation = new VitalObservation();
			observation.setType(observationType);
			this.vitalObservations.add(observation);
		}
		observation.setValue(observationValue);
	}

	@Override
	public Date getDate() {
		return getEntryDate();
	}
	
	@Override
	public boolean equals(Object paramObject) {
		if (paramObject != null && paramObject instanceof VitalEntry){
			VitalEntry paramVitalEntry = (VitalEntry) paramObject;
			if(this.getId() != null && paramVitalEntry.getId() != null){
				return this.getId().equals(paramVitalEntry.getId());
			}
		}
		
		return false;
	}
	
	@Override
	public int hashCode() {
		if(this.getId() != null){
			return this.getId().hashCode();	
		}else{
			return super.hashCode();
		}
	}

}
