package com.agilex.healthcare.mobilehealthplatform.domain;

public class ValidationResult<T> {
	private ValidationErrors<T> errors = new ValidationErrors<T>();

	public ValidationErrors<T> getErrors() {
		return errors;
	}

	public boolean isValid() {
		return errors.size() == 0;
	}

	public void setRequestObject(T requestObject) {
		errors.setRequestObject(requestObject);
	}

	public T getRequestObject() {
		return errors.getRequestObject();
	}

	public void addIfNotNull(ValidationError e) {
		if (e != null)
			this.errors.add(e);
	}
	
	public void addAll(ValidationErrors<T> list) {
		if (list != null) {
			for (ValidationError error : list) {
				this.errors.add(error);
			}
		}
	}
}
