package com.agilex.healthcare.mobilehealthplatform.domain;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "validationError", namespace = Namespace.MobileHealthPlatform)
public class ValidationError implements Serializable {
	private static final long serialVersionUID = 8972887733136598649L;

	@XmlAttribute
	private String fieldName;
	@XmlAttribute
	private String errorMessage;

	public ValidationError() {
	}

	public ValidationError(String errorMessage, String fieldName) {
		this.fieldName = fieldName;
		this.errorMessage = errorMessage;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public String getFieldName() {
		return fieldName;
	}

	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}

}
