package com.agilex.healthcare.mobilehealthplatform.domain;

import java.io.Serializable;
import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;


@XmlRootElement(namespace = Namespace.MobileHealthPlatform, name = "feedback")
@XmlAccessorType(value = XmlAccessType.NONE)
public class UserFeedback implements Serializable{
	private static final long serialVersionUID = 1459951628489298815L;

	public UserFeedback() {
	}

	@XmlElement
	private String uniqueId;
	
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date dateCreated;

	@XmlElement
	private String type;

	@XmlElement
	private AppointmentProcessedAsPerUserNeed appointmentProcessedAsPerUserNeed;
	
	@XmlElement
	private Integer recommendationRating; 
	
	@XmlElement
	private String comments;

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Integer getRecommendationRating() {
		return recommendationRating;
	}

	public void setRecommendationRating(Integer recommendationRating) {
		this.recommendationRating = recommendationRating;
	}

	public Date getDateCreated() {
		return dateCreated;
	}

	public void setDateCreated(Date dateCreated) {
		this.dateCreated = dateCreated;
	}

	public String getUniqueId() {
		return uniqueId;
	}

	public void setUniqueId(String uniqueId) {
		this.uniqueId = uniqueId;
	}

	public AppointmentProcessedAsPerUserNeed getAppointmentProcessedAsPerUserNeed() {
		return appointmentProcessedAsPerUserNeed;
	}

	public void setAppointmentProcessedAsPerUserNeed(
			AppointmentProcessedAsPerUserNeed appointmentProcessedAsPerUserNeed) {
		this.appointmentProcessedAsPerUserNeed = appointmentProcessedAsPerUserNeed;
	}

}
