package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.*;

import com.agilex.healthcare.utility.datemarshallers.*;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "toolTrackingResult", namespace = Namespace.MobileHealthPlatform)
public class ToolTrackingResult extends PatientData implements Dateable {

	private static final long serialVersionUID = -4434091232655224188L;

	@XmlElement
	private String tool;
	@XmlElement
	private String frequency;
	@XmlElement
	private Integer usefulness;
	@XmlElement
	private Integer successRate;
	@XmlJavaTypeAdapter(SimpleDateMarshaller.class)
	@XmlElement
	private Date dateTracked;

	public String getTool() {
		return tool;
	}

	public void setTool(String tool) {
		this.tool = tool;
	}

	public String getFrequency() {
		return frequency;
	}

	public void setFrequency(String frequency) {
		this.frequency = frequency;
	}

	public Integer getUsefulness() {
		return usefulness;
	}

	public void setUsefulness(Integer usefulness) {
		this.usefulness = usefulness;
	}

	public Integer getSuccessRate() {
		return successRate;
	}

	public void setSuccessRate(Integer successRate) {
		this.successRate = successRate;
	}

	public Date getDateTracked() {
		return dateTracked;
	}

	public void setDateTracked(Date dateTracked) {
		this.dateTracked = dateTracked;
	}

	@Override
	public Date getDate() {
		return this.dateTracked;
	}

}
