package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "toolCategory", namespace = Namespace.MobileHealthPlatform)
public class ToolCategory extends PatientData implements Comparable<ToolCategory> {
	private static final long serialVersionUID = 1L;

	@XmlElement
	private String name;
	private int recommendationCount = 0;

	public ToolCategory() {
		this.name = "";
	}

	public ToolCategory(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void increaseRecommendationCount() {
		this.recommendationCount++;
	}

	public int getRecommendationCount() {
		return recommendationCount;
	}

	public void setRecommendationCount(int count) {
		this.recommendationCount = count;
	}
	
	@Override
	public int compareTo(ToolCategory toolB) {
		int difference = toolB.getRecommendationCount() - this.getRecommendationCount();
		if (difference == 0) {
			difference = this.getName().compareTo(toolB.getName());
		}
		return difference;
	}

}
