package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "toolCategories", namespace = Namespace.MobileHealthPlatform)
public class ToolCategories extends PatientDataCollection<ToolCategory>{

	private static final long serialVersionUID = 1L;

	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<ToolCategory> getToolCategory() {
		return this;
	}

	public boolean containsTool(ToolCategory toolToFind) {
		for(ToolCategory toolToCompare : this) {
			if(toolToCompare.getName().equals(toolToFind.getName())) {
				return true;
			}
		}
		return false;
	}

	public ToolCategory getToolCategoryByName(String name) {
		for(ToolCategory toolToCompare : this) {
			if(toolToCompare.getName().equals(name)) {
				return toolToCompare;
			}
		}
		return null;
	}
}
