package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.utility.DateHelper;

@XmlRootElement(namespace = Namespace.MobileHealthPlatform, name = "tag")
@XmlAccessorType(value = XmlAccessType.NONE)
public class TimingKeyValuePair extends DomainTransferObject {

	private static final long serialVersionUID = -1281721448484465399L;
	
	@XmlAttribute
	private String key=null;
	@XmlAttribute
	private String value=null;

	public TimingKeyValuePair() {
	}

	public TimingKeyValuePair(String key, String value) {
		this.key = key;
		this.value = value;
	}

	public TimingKeyValuePair(String key, long value) {
		this.key = key;
		this.value = Long.toString(value);
	}

	public TimingKeyValuePair(String key, Date value) {
		this.key = key;
		this.value = DateHelper.formatDateTime(value);
	}

	public TimingKeyValuePair(String tag) {
		this.key = tag;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getKey() {
		return key;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getValue() {
		return value;
	}
}
