package com.agilex.healthcare.mobilehealthplatform.domain;

import java.net.URI;
import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlRootElement(namespace = Namespace.MobileHealthPlatform, name = "timing")
@XmlAccessorType(value = XmlAccessType.NONE)
public class TimingDto extends DomainTransferObject {
	
	private static final long serialVersionUID = -7193860758937276930L;
	
	@XmlElement
	protected String id;
	@XmlElement
	protected String parentId;
	@XmlElement
	protected long startTicks;
	@XmlElement
	protected long endTicks;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	protected Date startDate;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	protected Date endDate;
	@XmlElement
	protected String event;
	@XmlElement
	protected long timing;
	@XmlElement(name = "tag")
	protected TimingKeyValuePairs tags = new TimingKeyValuePairs();

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getParentId() {
		return parentId;
	}

	public void setParentId(String parentId) {
		this.parentId = parentId;
	}

	public String getEvent() {
		return event;
	}

	public void setEvent(String event) {
		this.event = event;
	}

	public TimingKeyValuePairs getTags() {
		return tags;
	}

	public void setTags(TimingKeyValuePairs tags) {
		this.tags = tags;
	}

	public void appendTag(String key, int value) {
		appendTag(key, Integer.toString(value));
	}

	public void appendTag(String key, Date value) {
		appendTag(key, DateHelper.formatDate(value));
	}

	public void appendTag(String key, String value) {
		tags.add(new TimingKeyValuePair(key, value));
	}

	public void appendTag(String tag) {
		tags.add(new TimingKeyValuePair(tag));
	}

	public void appendTag(String tag, URI uri) {
		appendTag(tag + "-path", uri.toString());
		if (uri.getQuery() != null)
			appendTag(tag + "-qs", uri.getQuery());
	}

	public long getTiming() {

		if (this.timing != 0)
			return this.timing;
		else if (NullChecker.isNotNullish(endTicks)
				&& NullChecker.isNotNullish(startTicks))
			return (endTicks - startTicks);
		else if (NullChecker.isNotNullish(startDate)
				&& NullChecker.isNotNullish(endDate))
			return DateHelper.calculateDeltaInMillis(startDate, endDate);
		else
			return 0;
	}

	public void setTiming(long timing) {
		this.timing = timing;
	}

	public long getStartTicks() {
		return startTicks;
	}

	public void setStartTicks(long startTicks) {
		this.startTicks = startTicks;
	}

	public long getEndTicks() {
		return endTicks;
	}

	public void setEndTicks(long endTicks) {
		this.endTicks = endTicks;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
}
