package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "telecom", namespace = Namespace.MobileHealthPlatform)
public class Telecom extends DomainTransferObject {
	// http://hl7.org/v3ballot/html/infrastructure/datatypes_r2/datatypes_r2.html#dt-TEL

	/**
	 * 
	 */
	private static final long serialVersionUID = 8903340561479359697L;
	@XmlAttribute
	private String type;
	@XmlAttribute
	private String value;

	public Telecom() {
	}

	public Telecom(String value, String type) {
		setValue(value);
		setType(type);
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getType() {
		return type;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getValue() {
		return value;
	}
}
