package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateMarshaller;

@XmlRootElement(name = "surgery", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class Surgery extends PatientData implements Dateable {

	private static final long serialVersionUID = -2193542150195224693L;
	@XmlAttribute
	private String procedure = null;
	@XmlAttribute
	private String facility = null;
	@XmlAttribute
	@XmlJavaTypeAdapter(DateMarshaller.class)
	private Date procedureDate = null;

	public String getProcedure() {
		return procedure;
	}

	public void setProcedure(String procedure) {
		this.procedure = procedure;
	}

	public String getFacility() {
		return facility;
	}

	public void setFacility(String facility) {
		this.facility = facility;
	}

	public Date getProcedureDate() {
		return procedureDate;
	}

	public void setProcedureDate(Date procedureDate) {
		this.procedureDate = procedureDate;
	}

	@Override
	@Transient
	public Date getDate() {
		return getProcedureDate();
	}

}
