package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshallerNoNulls;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "StaffUserDisclaimerInfo", namespace = Namespace.MobileHealthPlatform)
public class StaffUserDisclaimerInfo extends DomainTransferObject {
	private static final long serialVersionUID = 6000623591721455754L;
	@XmlElement
	private String vistaLocation = "";
	@XmlElement
	private String userId = "";
	@XmlElement
	private boolean staffUserDisclaimerAccepted = false;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshallerNoNulls.class)
	private Date staffUserDisclaimerDate = null;

	public StaffUserDisclaimerInfo() {
	}

	public StaffUserDisclaimerInfo(String vistaLocation, String userId, boolean accepted, Date date) {
		this.vistaLocation = vistaLocation;
		this.userId = userId;
		this.staffUserDisclaimerAccepted = accepted;
		this.staffUserDisclaimerDate = date;
	}

	public String getVistaLocation() {
		return vistaLocation;
	}

	public void setVistaLocation(String vistaLocation) {
		this.vistaLocation = vistaLocation;
	}
	
	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public boolean isStaffUserDisclaimerAccepted() {
		return staffUserDisclaimerAccepted;
	}

	public void setStaffUserDisclaimerAccepted(boolean accepted) {
		this.staffUserDisclaimerAccepted = accepted;
	}

	public Date getStaffUserDisclaimerDate() {
		return staffUserDisclaimerDate;
	}

	public void setStaffUserDisclaimerDate(Date date) {
		this.staffUserDisclaimerDate = date;
	}
}