package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshallerNoNulls;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "StaffUserDisclaimerContent", namespace = Namespace.MobileHealthPlatform)
public class StaffUserDisclaimerContent extends DomainTransferObject {
	private static final long serialVersionUID = -9100426596948034266L;

	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshallerNoNulls.class)
	private Date date = null;
	
	@XmlElement
	private String content = "";

	public StaffUserDisclaimerContent() {
	}

	public StaffUserDisclaimerContent(Date date, String content) {
		this.setDate(date);
		this.setContent(content);
	}

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}
}