package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "staffDirectorySearchResult", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class StaffDirectorySearchResult extends DomainTransferObject {

	private static final long serialVersionUID = -5101452382130959236L;

	@XmlElement
	private String name;
	@XmlElement
	private String title;
	@XmlElement
	private String cellPhone;
	@XmlElement
	private String officePhone;
	@XmlElement
	private String voicePager;
	@XmlElement
	private String digitalPager;
	@XmlElement
	private String facility;
	@XmlElement
	private String officeLocation;
	@XmlElement
	private String emailAddress;
	@XmlElement
	private String clinic;

	public StaffDirectorySearchResult() {
	}
	
	public StaffDirectorySearchResult(String name) {
		this.name = name;
	}
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getCellPhone() {
		return cellPhone;
	}

	public void setCellPhone(String cellPhone) {
		this.cellPhone = cellPhone;
	}

	public String getOfficePhone() {
		return officePhone;
	}

	public void setOfficePhone(String officePhone) {
		this.officePhone = officePhone;
	}

	public String getVoicePager() {
		return voicePager;
	}

	public void setVoicePager(String voicePager) {
		this.voicePager = voicePager;
	}

	public String getDigitalPager() {
		return digitalPager;
	}

	public void setDigitalPager(String digitalPager) {
		this.digitalPager = digitalPager;
	}

	public String getFacility() {
		return facility;
	}

	public void setFacility(String facility) {
		this.facility = facility;
	}

	public String getOfficeLocation() {
		return officeLocation;
	}

	public void setOfficeLocation(String officeLocation) {
		this.officeLocation = officeLocation;
	}

	public String getClinic() {
		return clinic;
	}

	public void setClinic(String clinic) {
		this.clinic = clinic;
	}

	public String getEmailAddress() {
		return emailAddress;
	}

	public void setEmailAddress(String emailAddress) {
		this.emailAddress = emailAddress;
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("name:");
		sb.append(name);
		sb.append(" title:");
		sb.append(title);
		sb.append(" cellPhone:");
		sb.append(cellPhone);
		sb.append(" officePhone:");
		sb.append(officePhone);
		sb.append(" voicePager:");
		sb.append(voicePager);
		sb.append(" digitalPager:");
		sb.append(digitalPager);
		sb.append(" facility:");
		sb.append(facility);
		sb.append(" officeLocation:");
		sb.append(officeLocation);
		sb.append(" emailAddress:");
		sb.append(emailAddress);
		sb.append(" clinic:");
		sb.append(clinic);
		
		return sb.toString();
	}
}
