package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "secureMessages", namespace = Namespace.MobileHealthPlatform)
public class SecureMessages extends PatientDataCollection<SecureMessage> {

	private static final long serialVersionUID = -1632712933337602618L;
	
	@XmlAttribute
	private int pageSize;
	@XmlAttribute
	private int pageNumber;
	private boolean hasNext = false;

	public SecureMessages() {}

	public SecureMessages(List<SecureMessage> messages) {
		this.addAll(messages);
	}
	
	public void addSecureMessage(SecureMessage secureMessage) {
	  this.add(secureMessage);
	}
	
	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<SecureMessage> getMessage() {
		return this;
	}

	public int getPageNumber() {
		return pageNumber;
	}

	public void setPageNumber(int pageNumber) {
		this.pageNumber = pageNumber;
	}

	public int getPageSize() {
		return pageSize;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	public boolean hasNext() {
		return hasNext;
	}

	public void setHasNext(boolean hasNext) {
		this.hasNext = hasNext;
	}

	public boolean hasPrevious() {
		if(pageNumber == 1 || pageNumber == 0)
			return false;
		
		return true;
	}
	
	public int nextPageNumber() {
		return pageNumber + 1;
	}
	
	public int previousPageNumber() {
		return pageNumber - 1;
	}
}
