package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "secureMessageUser", namespace = Namespace.MobileHealthPlatform)
public class SecureMessageUser extends PatientData {

	private static final String SAVE_DRAFT = "save-draft";
	private static final String SEND = "send";
	private static final String CONTACTS = "contacts";
	private static final String FOLDERS = "folders";

	private static final long serialVersionUID = 2051598411547929507L;

	@XmlAttribute
	private String secureMessageId;
	@XmlAttribute
	private String lastName;
	@XmlAttribute
	private String firstName;
	@XmlAttribute
	private String middleName;
	@XmlAttribute
	private String username;
	@XmlAttribute
	private String email;
	@XmlAttribute
	private String ssn;
	@XmlAttribute
	private Date lastNotification;

	public String getSecureMessageId() {
		return secureMessageId;
	}

	public void setSecureMessageId(String secureMessageId) {
		this.secureMessageId = secureMessageId;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getSsn() {
		return ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

	public Date getLastNotification() {
		return lastNotification;
	}

	public void setLastNotification(Date lastNotification) {
		this.lastNotification = lastNotification;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}
	
	@XmlElement
	public String getUri(){
		if(this.getSelfUri() != null){
			return getSelfUri().toString();
		}else{
			return null;
		}
	}

	@XmlElement
	public String getFoldersUri() {
		return getUriByTitle(FOLDERS);
	}

	@XmlElement
	public String getContactsUri() {
		return getUriByTitle(CONTACTS);
	}

	@XmlElement
	public String getSendUri() {
		return getUriByTitle(SEND);
	}

	@XmlElement
	public String getSaveDraftUri() {
		return getUriByTitle(SAVE_DRAFT);
	}

	private String getUriByTitle(String title){
		AtomLink link = getLink().getLinkByTitle(title);
		if (link != null) {
			return link.getHref().toString();
		} else {
			return null;
		}
	}
	
}
