package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "template", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class SecureMessageFolder extends PatientData {

	private static final long serialVersionUID = -9049242135550366766L;

	@XmlAttribute
	private String name;

	@XmlAttribute
	private boolean isSystemFolder;
	
	@XmlAttribute
	private boolean movable;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public boolean isMovable() {
		return movable;
	}

	public void setMovable(boolean movable) {
		this.movable = movable;
	}

	public boolean getSystemFolder() {
		return isSystemFolder;
	}

	public void setSystemFolder(boolean isSystemFolder) {
		this.isSystemFolder = isSystemFolder;
	}

	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("SecureMessagingFolder:id: " + getUniqueId());
		buffer.append("\nSecureMessagingFolder.name: " + name);
		buffer.append("\nSecureMessagingFolder.isSystemFolder: " + isSystemFolder);
		return buffer.toString();
	}

	

}
