package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "secureMessageContacts", namespace = Namespace.MobileHealthPlatform)
public class SecureMessageContacts extends PatientDataCollection<SecureMessageContact> {

	
	private static final long serialVersionUID = -1624930880495949228L;

	public SecureMessageContacts() {}

	public SecureMessageContacts(List<SecureMessageContact> contacts) {
		this.addAll(contacts);
	}
	
	public void addSecureMessage(SecureMessageContact secureMessageContact) {
	  this.add(secureMessageContact);
	}
	
	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<SecureMessageContact> getContact() {
		return this;
	}


	
}
