package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "secureMessageContact", namespace = Namespace.MobileHealthPlatform)
public class SecureMessageContact extends PatientData {
	

	private static final long serialVersionUID = -3945001913412335155L;
	
	@XmlAttribute
	private String name;
	@XmlAttribute
	private String emailAddress;
	

	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}


	public String getEmailAddress() {
		return emailAddress;
	}
	public void setEmailAddress(String emailAddress) {
		this.emailAddress = emailAddress;
	}


	public String toString() {
	  StringBuffer buffer = new StringBuffer();
	  buffer.append("SecureMessageContact.patientId: " + this.getPatientIdentifier());
	  buffer.append("\nSecureMessageContact.uniqueId: " + this.getUniqueId());
	  buffer.append("\nSecureMessageContact.name: " + name);
	  buffer.append("\nSecureMessageContact.emailAddress:" + emailAddress);	  
	  return buffer.toString();
	}
	



}
