package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "secureMessage", namespace = Namespace.MobileHealthPlatform)
public class SecureMessage extends PatientData implements Comparable<SecureMessage> {

	private static final long serialVersionUID = -1748682093342119300L;

	@XmlElement
	private String messageOplock;
	@XmlElement
	private String addresseeId;
	@XmlElement
	private String addresseeOplock;
	@XmlElement
	private String addresseeOwnerId;
	@XmlElement
	private String folderId;
	@XmlElement
	private String folder;
	@XmlElement
	private String from;
	@XmlElement
	private String fromId;
	@XmlElement
	private String to;
	@XmlElement
	private String toId;
	@XmlElement
	private String subjectCategory;
	@XmlElement
	private String subject;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date dateSent;
	@XmlElement
	private String messageBody;
	@XmlElement
	private String replyToMessageId;
	@XmlElement
	private String threadId = "0";
	@XmlElement
	private String threadOplock;
	@XmlElement
	private String mailGroup;
	@XmlElement
	private boolean isReply;
	

	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date completedDate;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date escalatedDate;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date escalationNotificationDate;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date readDate;
	
	public SecureMessage() {}
	
	public SecureMessage(SecureMessage another) {
		this.messageOplock = another.messageOplock;
		this.addresseeId = another.addresseeId;
		this.addresseeOplock = another.addresseeOplock;
		this.addresseeOwnerId = another.addresseeOwnerId;
		this.folderId = another.folderId;
		this.folder = another.folder;
		this.from = another.from;
		this.fromId = another.fromId;
		this.to = another.to;
		this.toId = another.toId;
		this.subjectCategory = another.subjectCategory;
		this.subject = another.subject;
		this.dateSent = another.dateSent;
		this.readDate = another.readDate;
		this.messageBody = another.messageBody;
		this.replyToMessageId = another.replyToMessageId;
		this.threadId = another.threadId;
		this.threadOplock = another.threadOplock;
		this.mailGroup = another.mailGroup;
		this.completedDate = another.completedDate;
		this.escalatedDate = another.escalatedDate;
		this.escalationNotificationDate = another.escalationNotificationDate;
		this.setPatientIdentifier(another.getPatientIdentifier());
		this.setDataIdentifier(another.getDataIdentifier());
	}
	
	public String getMessageOplock() {
		return messageOplock;
	}

	public void setMessageOplock(String messageOplock) {
		this.messageOplock = messageOplock;
	}

	public String getAddresseeId() {
		return addresseeId;
	}

	public void setAddresseeId(String addresseeId) {
		this.addresseeId = addresseeId;
	}

	public String getAddresseeOplock() {
		return addresseeOplock;
	}

	public void setAddresseeOplock(String addreseeOplock) {
		this.addresseeOplock = addreseeOplock;
	}

	public String getFrom() {
		return from;
	}

	public void setFrom(String from) {
		this.from = from;
	}

	public String getTo() {
		return to;
	}

	public void setTo(String to) {
		this.to = to;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public Date getDateSent() {
		return dateSent;
	}

	public void setDateSent(Date dateSent) {
		this.dateSent = dateSent;
	}

	public String getFolder() {
		return folder;
	}

	public void setFolder(String folder) {
		this.folder = folder;
	}

	public String getMessageBody() {
		return messageBody;
	}

	public void setMessageBody(String messageBody) {
		this.messageBody = messageBody;
	}

	public String getThreadId() {
		return threadId;
	}

	public void setThreadId(String threadId) {
		this.threadId = threadId;
	}

	public String getFromId() {
		return fromId;
	}

	public void setFromId(String fromId) {
		this.fromId = fromId;
	}

	public String getToId() {
		return toId;
	}

	public void setToId(String toId) {
		this.toId = toId;
	}

	public String getSubjectCategory() {
		return subjectCategory;
	}

	public void setSubjectCategory(String subjectCategory) {
		this.subjectCategory = subjectCategory;
	}

	public String getReplyToMessageId() {
		return replyToMessageId;
	}

	public void setReplyToMessageId(String replyToMessageId) {
		this.replyToMessageId = replyToMessageId;
	}

	public String getAddresseeOwnerId() {
		return addresseeOwnerId;
	}

	public void setAddresseeOwnerId(String addresseeOwnerId) {
		this.addresseeOwnerId = addresseeOwnerId;
	}

	public String getFolderId() {
		return folderId;
	}

	public void setFolderId(String folderId) {
		this.folderId = folderId;
	}

	public String getThreadOplock() {
		return threadOplock;
	}

	public void setThreadOplock(String threadOplock) {
		this.threadOplock = threadOplock;
	}

	public String getMailGroup() {
		return mailGroup;
	}

	public void setMailGroup(String mailGroup) {
		this.mailGroup = mailGroup;
	}

	public Date getCompletedDate() {
		return completedDate;
	}

	public void setCompletedDate(Date completedDate) {
		this.completedDate = completedDate;
	}

	public Date getEscalatedDate() {
		return escalatedDate;
	}

	public void setEscalatedDate(Date escalatedDate) {
		this.escalatedDate = escalatedDate;
	}

	public Date getEscalationNotificationDate() {
		return escalationNotificationDate;
	}

	public void setEscalationNotificationDate(Date escalationNotificationDate) {
		this.escalationNotificationDate = escalationNotificationDate;
	}
	
	public Date getReadDate() {
		return readDate;
	}

	public void setReadDate(Date readDate) {
		this.readDate = readDate;
	}

	public boolean isReply() {
		return isReply;
	}

	public void setReply(boolean isReply) {
		this.isReply = isReply;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((addresseeId == null) ? 0 : addresseeId.hashCode());
		result = prime * result + ((addresseeOplock == null) ? 0 : addresseeOplock.hashCode());
		result = prime * result + ((addresseeOwnerId == null) ? 0 : addresseeOwnerId.hashCode());
		result = prime * result + ((completedDate == null) ? 0 : completedDate.hashCode());
		result = prime * result + ((dateSent == null) ? 0 : dateSent.hashCode());
		result = prime * result + ((escalatedDate == null) ? 0 : escalatedDate.hashCode());
		result = prime * result + ((escalationNotificationDate == null) ? 0 : escalationNotificationDate.hashCode());
		result = prime * result + ((folder == null) ? 0 : folder.hashCode());
		result = prime * result + ((folderId == null) ? 0 : folderId.hashCode());
		result = prime * result + ((from == null) ? 0 : from.hashCode());
		result = prime * result + ((fromId == null) ? 0 : fromId.hashCode());
		result = prime * result + ((mailGroup == null) ? 0 : mailGroup.hashCode());
		result = prime * result + ((messageBody == null) ? 0 : messageBody.hashCode());
		result = prime * result + ((messageOplock == null) ? 0 : messageOplock.hashCode());
		result = prime * result + ((replyToMessageId == null) ? 0 : replyToMessageId.hashCode());
		result = prime * result + ((subject == null) ? 0 : subject.hashCode());
		result = prime * result + ((subjectCategory == null) ? 0 : subjectCategory.hashCode());
		result = prime * result + ((threadId == null) ? 0 : threadId.hashCode());
		result = prime * result + ((threadOplock == null) ? 0 : threadOplock.hashCode());
		result = prime * result + ((to == null) ? 0 : to.hashCode());
		result = prime * result + ((toId == null) ? 0 : toId.hashCode());
		return result;
	}
	


	@Override
	public boolean equals(Object obj) {
		if(obj == null)
			return false;
		if (this == obj)
			return true;
		if (getClass() != obj.getClass())
			return false;
		SecureMessage other = (SecureMessage) obj;
		
		if (getUniqueId() == null) {
			if (other.getUniqueId() != null)
				return false;
		} else if (!getUniqueId().equals(other.getUniqueId()))
			return false;
		if (addresseeId == null) {
			if (other.addresseeId != null)
				return false;
		} else if (!addresseeId.equals(other.addresseeId))
			return false;
		if (addresseeOwnerId == null) {
			if (other.addresseeOwnerId != null)
				return false;
		} else if (!addresseeOwnerId.equals(other.addresseeOwnerId))
			return false;
		if (from == null) {
			if (other.from != null)
				return false;
		} else if (!from.equals(other.from))
			return false;
		if (fromId == null) {
			if (other.fromId != null)
				return false;
		} else if (!fromId.equals(other.fromId))
			return false;
		if (mailGroup == null) {
			if (other.mailGroup != null)
				return false;
		} else if (!mailGroup.equals(other.mailGroup))
			return false;
		if (messageOplock == null) {
			if (other.messageOplock != null)
				return false;
		} else if (!messageOplock.equals(other.messageOplock))
			return false;
		if (replyToMessageId == null) {
			if (other.replyToMessageId != null)
				return false;
		} else if (!replyToMessageId.equals(other.replyToMessageId))
			return false;
		if (subject == null) {
			if (other.subject != null)
				return false;
		} else if (!subject.equals(other.subject))
			return false;
		if (subjectCategory == null) {
			if (other.subjectCategory != null)
				return false;
		} else if (!subjectCategory.equals(other.subjectCategory))
			return false;
		if (threadId == null) {
			if (other.threadId != null)
				return false;
		} else if (!threadId.equals(other.threadId))
			return false;
		if (threadOplock == null) {
			if (other.threadOplock != null)
				return false;
		} else if (!threadOplock.equals(other.threadOplock))
			return false;
		if (to == null) {
			if (other.to != null)
				return false;
		} else if (!to.equals(other.to))
			return false;
		if (toId == null) {
			if (other.toId != null)
				return false;
		} else if (!toId.equals(other.toId))
			return false;
		return true;
	}

	@Override
	public int compareTo(SecureMessage that) {
		if(SecureMessageCode.FOLDER_ID_DRAFT.toString().equals(this.folderId)) {
			Integer thisId = Integer.parseInt(this.getAddresseeId());
			Integer thatId = Integer.parseInt(that.getAddresseeId());
			
			return thisId.compareTo(thatId) * -1;
		} else {
			return (this.getDateSent().compareTo(that.getDateSent()) * -1);
		}
	}
}
