package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshallerNoNulls;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "RightOfAccessInfo", namespace = Namespace.MobileHealthPlatform)
public class RightOfAccessInfo extends PatientData {

	private static final long serialVersionUID = 6592631019609072089L;
	@XmlElement
	private String userId = "";
	@XmlElement
	private boolean rightOfAccessAccepted = false;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshallerNoNulls.class)
	private Date rightOfAccessDate = null;
	@XmlTransient
	private byte[] rightOfAccessPDF;

	public RightOfAccessInfo() {
	}

	public RightOfAccessInfo(String userId, boolean accepted, Date date) {
		this.userId = userId;
		this.rightOfAccessAccepted = accepted;
		this.rightOfAccessDate = date;
	}
	
	public RightOfAccessInfo(String userId, boolean accepted, Date date, byte [] pdf) {
		this.userId = userId;
		this.rightOfAccessAccepted = accepted;
		this.rightOfAccessDate = date;
		this.rightOfAccessPDF = pdf;
	}
	
	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public boolean isRightOfAccessAccepted() {
		return rightOfAccessAccepted;
	}

	public void setRightOfAccessAccepted(boolean accepted) {
		this.rightOfAccessAccepted = accepted;
	}

	public Date getRightOfAccessDate() {
		return rightOfAccessDate;
	}

	public void setRightOfAccessDate(Date date) {
		this.rightOfAccessDate = date;
	}

	public byte[] getRightOfAccessPDF() {
		return rightOfAccessPDF;
	}

	public void setRightOfAccessPDF(byte[] rightOfAccessPDF) {
		this.rightOfAccessPDF = rightOfAccessPDF;
	}
}