package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name = "DOCUMENT_DOMAIN")
@XmlRootElement(name = "documentDomain", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class RelatedDataItem {

	@XmlAttribute(name="id")
	private String documentDomainId = null;

	@XmlAttribute
	private String domain = null;

	@XmlElement(name="identifier")
	private DataIdentifier dataIdentifier = new DataIdentifier();

	private Document document;

	public RelatedDataItem() {
	}

	public RelatedDataItem(String domain, DataIdentifier identifier) {
		this.domain = domain;
		this.dataIdentifier = identifier;
	}

	public RelatedDataItem(String domain, String uniqueId, String communityId) {
		this.domain = domain;
		this.setUniqueId(uniqueId);
		this.setCommunityId(communityId);
	}

	@Id
	@GeneratedValue
	@Column(name = "DOCUMENT_DOMAIN_ID")
	public String getDocumentDomainId() {
		return documentDomainId;
	}

	public void setDocumentDomainId(String id) {
		this.documentDomainId = id;
	}

	@Column(name = "DOMAIN")
	public String getDomain() {
		return domain;
	}

	public void setDomain(String domain) {
		this.domain = domain;
	}

	@Transient
	public DataIdentifier getIdentifier() {
		return dataIdentifier;
	}

	public void setIdentifier(DataIdentifier identifier) {
		this.dataIdentifier = identifier;
	}

	@Column(name = "UNIQUE_ID")
	public String getUniqueId() {
		return this.dataIdentifier.getUniqueId();
	}

	public void setUniqueId(String uniqueId) {
		this.dataIdentifier.setUniqueId(uniqueId);
	}

	@Column(name = "COMMUNITY_ID")
	public String getCommunityId() {
		return this.dataIdentifier.getSystemId();
	}

	public void setCommunityId(String communityId) {
		this.dataIdentifier.setSystemId(communityId);
	}

	@OneToOne(optional=false)
	@JoinColumn(name = "DOCUMENT_ID", nullable=false)
	public Document getDocument() {
		return document;
	}

	public void setDocument(Document document) {
		this.document = document;
	}

}
