package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.utility.NullSafeStringComparer;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "radiologyTests", namespace = Namespace.MobileHealthPlatform)
public class RadiologyTests extends PatientDataCollection<RadiologyTest> {

	private static final long serialVersionUID = 8603919429235030250L;

	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<RadiologyTest> getRadiologyTest() {
		return this;
	}

	public RadiologyTest getTestById(String testId) {
		RadiologyTest match = null;
		for (RadiologyTest potentialMatch : this) {
			if (NullSafeStringComparer.areEqual(potentialMatch.getShortName(), testId))
				match = potentialMatch;
		}
		return match;
	}
}
