package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "radiologyTest", namespace = Namespace.MobileHealthPlatform)
public class RadiologyTest extends PatientData {

	private static final long serialVersionUID = -285796283153908708L;

	@XmlAttribute
	private String shortName = null;
	@XmlAttribute
	private String testName = null;
	@XmlElement(name = "mostRecentRadiologyResult", namespace = Namespace.MobileHealthPlatform)
	private RadiologyResult mostRecentRadiologyResult = null;
	@XmlElement(name = "radiologyResults", namespace = Namespace.MobileHealthPlatform)
	private RadiologyResults radiologyResults = new RadiologyResults();

	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	public String getTestName() {
		return testName;
	}

	public void setTestName(String testName) {
		this.testName = testName;
	}

	public RadiologyResult getMostRecentRadiologyResult() {
		return mostRecentRadiologyResult;
	}

	public void setMostRecentRadiologyResult(RadiologyResult mostRecentRadiologyResult2) {
		this.mostRecentRadiologyResult = mostRecentRadiologyResult2;
	}

	public RadiologyResults getRadiologyResults() {
		return radiologyResults;
	}

	public void setRadiologyResults(RadiologyResults radiologyResults) {
		this.radiologyResults = radiologyResults;
	}
}
