package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlRootElement(namespace = Namespace.MobileHealthPlatform)
public class RadiologyResult extends PatientData implements Dateable {

	private static final long serialVersionUID = -6117192768523788878L;

	@XmlAttribute
	private String testId = null;
	@XmlAttribute
	private String testShortName = null;
	@XmlAttribute
	private String testName = null;
	@XmlAttribute
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date resultedDate = null;
	@XmlAttribute
	private String facilityName = null;
	@XmlAttribute
	private String interpretation = null;
	@XmlElement
	private String report = null;

	public String getTestId() {
		return testId;
	}

	public void setTestId(String testId) {
		this.testId = testId;
	}

	public String getTestShortName() {
		return testShortName;
	}

	public void setTestShortName(String testShortName) {
		this.testShortName = testShortName;
	}

	public String getTestName() {
		return testName;
	}

	public void setTestName(String testName) {
		this.testName = testName;
	}

	public Date getResultedDate() {
		return resultedDate;
	}

	public void setResultedDate(Date resultedDate) {
		this.resultedDate = resultedDate;
	}

	public String getInterpretation() {
		return interpretation;
	}

	public void setInterpretation(String interpretation) {
		this.interpretation = interpretation;
	}

	public String getReport() {
		return report;
	}

	public void setReport(String report) {
		this.report = report;
	}

	public void setFacilityName(String facilityName) {
		this.facilityName = facilityName;
	}

	public String getFacilityName() {
		return facilityName;
	}

	@Override
	public Date getDate() {
		return getResultedDate();
	}

}
