package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;


@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "providerNote", namespace = Namespace.MobileHealthPlatform)
public class ProviderNote extends PatientData implements Dateable {

	private static final long serialVersionUID = 5767042194635913879L;
	
	public ProviderNote() {}
	
	public ProviderNote(String text) {
		this.text = text;
	}

	@XmlElement
	private String text;
	
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date entryDate;

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public Date getEntryDate() {
		return entryDate;
	}

	public void setEntryDate(Date entryDate) {
		this.entryDate = entryDate;
	}

	@Override
	public Date getDate() {
		return getEntryDate();
	}

}
