package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.HashSet;
import java.util.Set;

import com.agilex.healthcare.utility.NullChecker;


public class Provider {

	protected String lastName;
	protected String firstName;
	protected String middleInitials;
	private Set<String> vistaLocations;
	private String title;
	private String cellPhone;
	private String officePhone;
	private String voicePager;
	private String digitalPager;
	private String emailAddress;
	private String officeLocation;
	
	public Provider() {
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getMiddleInitials() {
		return middleInitials;
	}

	public void setMiddleInitials(String middleInitials) {
		this.middleInitials = middleInitials;
	}

	public String getDisplayName() {
		StringBuilder sb = new StringBuilder();
		sb.append(firstName);
		if (NullChecker.isNotNullish(middleInitials)) {
			sb.append(" ");
			sb.append(middleInitials);
		}
		sb.append(" ");
		sb.append(lastName);
		
		return sb.toString();
	}
	
    public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getCellPhone() {
		return cellPhone;
	}

	public void setCellPhone(String cellPhone) {
		this.cellPhone = cellPhone;
	}

	public String getOfficePhone() {
		return officePhone;
	}

	public void setOfficePhone(String officePhone) {
		this.officePhone = officePhone;
	}

	public String getVoicePager() {
		return voicePager;
	}

	public void setVoicePager(String voicePager) {
		this.voicePager = voicePager;
	}

	public String getDigitalPager() {
		return digitalPager;
	}

	public void setDigitalPager(String digitalPager) {
		this.digitalPager = digitalPager;
	}

	public String getEmailAddress() {
		return emailAddress;
	}

	public void setEmailAddress(String emailAddress) {
		this.emailAddress = emailAddress;
	}

	public Set<String> getVistaLocations() {
		if (this.vistaLocations == null) {
			this.vistaLocations = new HashSet<String>();
		}
		return vistaLocations;
	}

	public void setVistaLocations(Set<String> vistaLocations) {
		this.vistaLocations = vistaLocations;
	}

	public void addVistaLocation(String vistaLocation) {
		if (this.vistaLocations == null) {
			this.vistaLocations = new HashSet<String>();
		}
		this.vistaLocations.add(vistaLocation);
	}
	
	public void removeVistaLocation(String vistaLocation) {
		if (this.vistaLocations != null) {
			this.vistaLocations.remove(vistaLocation);	
		}
	}

	public String getOfficeLocation() {
		return officeLocation;
	}

	public void setOfficeLocation(String officeLocation) {
		this.officeLocation = officeLocation;
	}
}
