package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;
import java.util.Locale;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateMarshaller;
import com.agilex.healthcare.utility.datemarshallers.SimpleDateMarshaller;

@XmlRootElement(name = "problem")
@XmlAccessorType(value = XmlAccessType.NONE)
public class Problem extends PatientData implements Comparable<Problem>, Dateable {

	private static final long serialVersionUID = 7612716894391486643L;

	@XmlAttribute
	private String description = null;
	@XmlJavaTypeAdapter(DateMarshaller.class)
	@XmlAttribute
	private Date onsetDate = null;
	@XmlJavaTypeAdapter(SimpleDateMarshaller.class)
	@XmlAttribute
	private Date resolutionDate = null;	
	@XmlJavaTypeAdapter(SimpleDateMarshaller.class)
	@XmlAttribute
	private Date lastUpdatedDate = null;
	@XmlAttribute
	private String comments = null;
	@XmlAttribute
	private boolean active = true;
	@XmlAttribute
	private String priority = null;

	public Problem() {}
	
	public Problem(DataIdentifier dataIdentifier, PatientIdentifier patientIdentifier, String description, Date onsetDate, Date resolutionDate, Date lastUpdatedDate,
			String comments, boolean active, String priority, String sourceSystem) {
		this.setDataIdentifier(dataIdentifier);
		this.setPatientIdentifier(patientIdentifier);
		this.description = description;
		this.onsetDate = onsetDate;
		this.resolutionDate= resolutionDate;
		this.lastUpdatedDate= lastUpdatedDate;
		this.comments= comments;
		this.active = active;
		this.priority = priority;	
		this.setSourceSystem(stripSiteCodeFromFacilityName(sourceSystem));
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getDescription() {
		return description;
	}

	public Date getOnsetDate() {
		return onsetDate;
	}

	public void setOnsetDate(Date onset) {
		this.onsetDate = onset;
	}

	public void setResolutionDate(Date resolution) {
		this.resolutionDate = resolution;
	}

	public Date getResolutionDate() {
		return resolutionDate;
	}

	public String getProblemId() {
		return getUniqueId();
	}

	public void setProblemId(String problemId) {
		setUniqueId(problemId);
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getComments() {
		return comments;
	}

	public void setPriority(String priority) {
		this.priority = priority;
	}

	public String getPriority() {
		return priority;
	}

	public void setActive(boolean active) {
		this.active = active;
	}

	public boolean isActive() {
		return active;
	}

	public Date getLastUpdatedDate() {
		return lastUpdatedDate;
	}

	public void setLastUpdatedDate(Date lastUpdatedDate) {
		this.lastUpdatedDate = lastUpdatedDate;
	}

	@Override
	public int compareTo(Problem o) {
		int result;

		if (this.getDescription() == null || o.getDescription() == null) {
			if (this.getDescription() == null && o.getDescription() == null) {
				result = 0;
			} else if (this.getDescription() == null) {
				result = -1;
			} else {
				result = 1;
			}
		} else {
			result = this.getDescription().toLowerCase(Locale.ENGLISH).compareTo(o.getDescription().toLowerCase(Locale.ENGLISH));
		}

		return result;
	}

	@Override
	public Date getDate() {
		return getOnsetDate();
	}
	
	private String stripSiteCodeFromFacilityName(String facilityName) {
		if (facilityName != null && facilityName.contains("("))
			return matchFacilityName(facilityName);

		return facilityName;
	}

	String matchFacilityName(String facilityName) {
		// Matches something like "(321) City Name, ST" -> {"(321)",
		// "City Name, ST"}
		String altered = facilityName.replaceAll("\\([0-9]{3,4}\\)", "");
		return altered.trim();

	}
}
