package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.persistence.*;

@Entity
@Table(name="PUBLIC_KEY")
public class PatientPublicKey extends PatientData {

	private static final long serialVersionUID = 675102615212814153L;
	
	public PatientPublicKey() {}
	
	public PatientPublicKey(String publicKey, String patientId) {
		setPublicKey(publicKey);
		setPatientId(patientId);
	}

	@Id
	@Column(name="PUBLIC_KEY")
	public String getPublicKey() {
		return getDataIdentifier().getUniqueId();
	}
	
	public void setPublicKey(String publicKey) {
		getDataIdentifier().setUniqueId(publicKey);
	}
	
	@Column(name="USER_ID")
	public String getPatientId() {
		return getPatientIdentifier().getUniqueId();
	}
	
	public void setPatientId(String patientId) {
		getPatientIdentifier().setUniqueId(patientId);
	}
	
}
