package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "provider")
@XmlAccessorType(value = XmlAccessType.NONE)
public class PatientProvider extends PatientData implements Dateable, Comparable<PatientProvider> {

	private static final long serialVersionUID = -390106765231877420L;

	@XmlElement
	private String providerId;
	
	@XmlElement
	private String providerName;
	
	@XmlElement
	private String personClass;
	
	@XmlElement
	private Date visitDate;
	
	
	@Override
	public int compareTo(PatientProvider o) {
		int result;
		
		if (this.getProviderId() == null || o.getProviderId() == null) {
				result = -1;
		} else {
			result = this.getProviderId().compareTo(o.getProviderId());	
		}
		
		return result;
	}

	public String getProviderId() {
		return providerId;
	}

	public void setProviderId(String providerId) {
		this.providerId = providerId;
	}

	public String getProviderName() {
		return providerName;
	}

	public void setProviderName(String providerName) {
		this.providerName = providerName;
	}

	public String getPersonClass() {
		return personClass;
	}

	public void setPersonClass(String personClass) {
		this.personClass = personClass;
	}

	@Override
	public Date getDate() {
		return visitDate;
	}

	public Date getVisitDate() {
		return visitDate;
	}

	public void setVisitDate(Date visitDate) {
		this.visitDate = visitDate;
	}


}
