package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "patientMetadata", namespace = Namespace.MobileHealthPlatform)
public class PatientMetadata extends PatientData {

	private static final long serialVersionUID = -613294957626640127L;

	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date lastAppointmentRequestAccessDate;
	
	public Date getLastAppointmentRequestAccessDate() {
		return lastAppointmentRequestAccessDate;
	}

	public void setLastAppointmentRequestAccessDate(Date lastAppointmentRequestAccessDate) {
		this.lastAppointmentRequestAccessDate = lastAppointmentRequestAccessDate;
	}
}
