package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.ArrayList;
import java.util.Set;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "patientIdentifiers", namespace = Namespace.MobileHealthPlatform)
public class PatientIdentifiers extends ArrayList<PatientIdentifier> {
	
	private static final long serialVersionUID = 6526466826229690789L;
	
	public PatientIdentifiers() {}
	
	public PatientIdentifiers(PatientIdentifier... patientIdentifiers) {
		for(PatientIdentifier patientIdentifier : patientIdentifiers) {
			this.add(patientIdentifier);
		}
	}
	
	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public PatientIdentifiers getPatientIdentifier() {
		return this;
	}
	
	public static PatientIdentifiers fromSet(Set<PatientIdentifier> set) {
		PatientIdentifiers patientIdentifiers = new PatientIdentifiers();
		for (PatientIdentifier patientIdentifier : set) {
			patientIdentifiers.add(patientIdentifier);
		}
		return patientIdentifiers;
	}
}
