package com.agilex.healthcare.mobilehealthplatform.domain;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.NullSafeStringComparer;

@XmlRootElement(name = "patient-identifier", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class PatientIdentifier implements Serializable {
	private static final String ICN = "icn";

	private static final long serialVersionUID = 2614725045007187646L;
	
	@XmlElement
	private String uniqueId;
	@XmlElement
	private String assigningAuthority; // tied to issuer / source

	public PatientIdentifier() {
	}

	public PatientIdentifier(String assigningAuthority, String uniqueId) {
		this.setAssigningAuthority(assigningAuthority);
		this.setUniqueId(uniqueId);
	}

	public PatientIdentifier createCopy() {
		return new PatientIdentifier(this.getAssigningAuthority(), this.getUniqueId());
	}

	@Override
	public boolean equals(Object o) {
		if (o == null) {
			return false;
		}
		if (!(o instanceof PatientIdentifier)) {
			return false;
		}

		PatientIdentifier patientIdentifier = (PatientIdentifier) o;

		// PatientIdentifier can contain AA as icn-{siteCode} and ICN is unique across VA. So, icn-588#123 should be equal to icn-355#123
		if (this.assigningAuthority != null && this.assigningAuthority.toLowerCase().contains(ICN) && 
				patientIdentifier.getAssigningAuthority() != null && patientIdentifier.getAssigningAuthority().toLowerCase().contains(ICN)){
			return (areStringsEqual(patientIdentifier.getUniqueId(), this.getUniqueId()));
		}else{
			return (areStringsEqual(patientIdentifier.getAssigningAuthority(), this.getAssigningAuthority()) 
					&& areStringsEqual(patientIdentifier.getUniqueId(), this.getUniqueId()));
		}
			
	}

	@Override
	public int hashCode() {
		String s = toString();
		if (NullChecker.isNullish(s))
			s = "";
		return s.hashCode();
	}

	private boolean areStringsEqual(String a, String b) {
		return NullSafeStringComparer.areEqual(a, b);
	}

	public String getUniqueId() {
		return uniqueId;
	}

	public void setUniqueId(String uniqueId) {
		this.uniqueId = uniqueId;
	}

	public String getAssigningAuthority() {
		return assigningAuthority;
	}

	public void setAssigningAuthority(String assigningAuthority) {
		this.assigningAuthority = assigningAuthority;
	}

	@Override
	public String toString() {
		final String delimitor = "#";
		String s;
		if (NullChecker.isNullish(uniqueId)) {
			s = null;
		} else if (NullChecker.isNullish(assigningAuthority)) {
			s = uniqueId;
		} else {
			s = assigningAuthority + delimitor + uniqueId;
		}
		return s;
	}

}
