package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name = "patientEdipiIcn", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class PatientEdipiIcn extends DomainTransferObject {

	private static final long serialVersionUID = -5463077479429232929L;

	private String id = null;
	@XmlAttribute
	private String edipi;
	@XmlAttribute
	private String icn;
	@XmlTransient
	private boolean activeFlag = true;
	@XmlAttribute
	private Date createdDate;
	
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getEdipi() {
		return edipi;
	}
	public void setEdipi(String edipi) {
		this.edipi = edipi;
	}
	public String getIcn() {
		return icn;
	}
	public void setIcn(String icn) {
		this.icn = icn;
	}
	public boolean isActiveFlag() {
		return activeFlag;
	}
	public void setActiveFlag(boolean activeFlag) {
		this.activeFlag = activeFlag;
	}
	public Date getCreatedDate() {
		return createdDate;
	}
	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}
	
	@Override
	public int hashCode() {
		return (this.edipi.hashCode() + this.icn.hashCode());
	}
	
	@Override
	public boolean equals(Object obj) {

	    if(obj instanceof PatientEdipiIcn)
	    {
	    	PatientEdipiIcn temp = (PatientEdipiIcn) obj;
	        if(this.edipi.equalsIgnoreCase(temp.edipi) && this.icn.equalsIgnoreCase(temp.icn))
	            return true;
	    }
	    return false;
	}	    

}