package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "demographics", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class PatientDemographics extends PatientData {

	private static final long serialVersionUID = -3286093223335726440L;

	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	private NextOfKin nextOfKin = null;
	@XmlAttribute
	private String emailAddress = null;
	@XmlElement
	private Addresses addresses;
	@XmlElement
	private PhoneNumbers phoneNumbers;
	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	private Address address = null;
	@XmlAttribute
	private String phoneNumberPager;
	@XmlAttribute
	private String phoneNumberMobile;
	@XmlAttribute
	private String phoneNumberHome;
	@XmlAttribute
	private String phoneNumberWork;

	public void setNextOfKin(NextOfKin nextOfKin) {
		this.nextOfKin = nextOfKin;
	}

	public NextOfKin getNextOfKin() {
		return nextOfKin;
	}

	public String getEmailAddress() {
		return emailAddress;
	}

	public void setEmailAddress(String emailAddress) {
		this.emailAddress = emailAddress;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public void setAddress(Address address) {
		this.address = address;
	}

	public Address getAddress() {
		if (this.address == null)
			this.address = new Address();
		return address;
	}

	public void setPhoneNumberPager(String phoneNumberPager) {
		this.phoneNumberPager = phoneNumberPager;
	}

	public String getPhoneNumberPager() {
		return phoneNumberPager;
	}

	public void setPhoneNumberMobile(String phoneNumberMobile) {
		this.phoneNumberMobile = phoneNumberMobile;
	}

	public String getPhoneNumberMobile() {
		return phoneNumberMobile;
	}

	public void setPhoneNumberHome(String phoneNumberHome) {
		this.phoneNumberHome = phoneNumberHome;
	}

	public String getPhoneNumberHome() {
		return phoneNumberHome;
	}

	public void setPhoneNumberWork(String phoneNumberWork) {
		this.phoneNumberWork = phoneNumberWork;
	}

	public String getPhoneNumberWork() {
		return phoneNumberWork;
	}

	public Addresses getAddresses() {
		return addresses;
	}

	public void setAddresses(Addresses addresses) {
		this.addresses = addresses;
	}

	public PhoneNumbers getPhoneNumbers() {
		return phoneNumbers;
	}

	public void setPhoneNumbers(PhoneNumbers phoneNumbers) {
		this.phoneNumbers = phoneNumbers;
	}

}
